#   File:       Slime Volley.make
#   Target:     Slime Volley
#   Created:    Saturday, December 6, 2008 07:46:43 PM


MAKEFILE        = "Slime Volley.make"
MondoBuild    = {MAKEFILE}  # Make blank to avoid rebuilds when makefile is modified

ObjDir          = :obj:
Includes        =  
				  -i :include: 
				  -i "::src:" 
				  -i :

Sym-PPC         = -sym off

PPCCOptions     = {Includes} {Sym-PPC}  -enum int


### Source Files ###

SrcFiles        =  
				  "::src:audio.c" 
				  "::src:clavier.c" 
				  "::src:credits.c" 
				  "::src:echelle.c" 
				  "::src:IA.c" 
				  "::src:jeu.c" 
				  "::src:menu.c" 
				  "::src:menu_jeu.c" 
				  "::src:menu_options.c" 
				  "::src:menu_princ.c" 
				  "::src:objet.c" 
				  "::src:reseau.c" 
				  "::src:reseau_inter.c" 
				  "::src:slime.c" 
				  "::src:themes_general.c" 
				  "::src:themes_os9.c" 
				  :rsrc:SDL.r 
				  :rsrc:slime.r


### Object Files ###

ObjFiles-PPC    =  
				  "{ObjDir}audio.c.x" 
				  "{ObjDir}clavier.c.x" 
				  "{ObjDir}credits.c.x" 
				  "{ObjDir}echelle.c.x" 
				  "{ObjDir}IA.c.x" 
				  "{ObjDir}jeu.c.x" 
				  "{ObjDir}menu.c.x" 
				  "{ObjDir}menu_jeu.c.x" 
				  "{ObjDir}menu_options.c.x" 
				  "{ObjDir}menu_princ.c.x" 
				  "{ObjDir}objet.c.x" 
				  "{ObjDir}reseau.c.x" 
				  "{ObjDir}reseau_inter.c.x" 
				  "{ObjDir}slime.c.x" 
				  "{ObjDir}themes_general.c.x" 
				  "{ObjDir}themes_os9.c.x"


### Libraries ###

LibFiles-PPC    =  
				   ":lib:SDLmain.o" ":lib:SDL" ":lib:SDL_image" ":lib:SDL_ttf" ":lib:SDL_net" 
				   "{SharedLibraries}InterfaceLib" 
				   "{SharedLibraries}StdCLib" 
				   "{SharedLibraries}MathLib" 
				   "{PPCLibraries}StdCRuntime.o" 
				   "{PPCLibraries}PPCCRuntime.o" 
				   "{PPCLibraries}PPCToolLibs.o"


### Default Rules ###

.c.x    .c  {MondoBuild}
	{PPCC} {depDir}{default}.c -o {targDir}{default}.c.x {PPCCOptions}


### Build Rules ###

"Slime Volley"    {ObjFiles-PPC} {LibFiles-PPC} {MondoBuild}
	PPCLink 
		-o {Targ} 
		{ObjFiles-PPC} 
		{LibFiles-PPC} 
		{Sym-PPC} 
		-mf -d 
		-t 'APPL' 
		-c 'SlVl'


"Slime Volley"    :rsrc:SDL.r {MondoBuild}
	Rez :rsrc:SDL.r -o {Targ} {Includes} -append

"Slime Volley"    :rsrc:slime.r {MondoBuild}
	Rez :rsrc:slime.r -o {Targ} {Includes} -append


### Required Dependencies ###

"{ObjDir}audio.c.x"    "::src:audio.c"
"{ObjDir}clavier.c.x"    "::src:clavier.c"
"{ObjDir}credits.c.x"    "::src:credits.c"
"{ObjDir}echelle.c.x"    "::src:echelle.c"
"{ObjDir}IA.c.x"    "::src:IA.c"
"{ObjDir}jeu.c.x"    "::src:jeu.c"
"{ObjDir}menu.c.x"    "::src:menu.c"
"{ObjDir}menu_jeu.c.x"    "::src:menu_jeu.c"
"{ObjDir}menu_options.c.x"    "::src:menu_options.c"
"{ObjDir}menu_princ.c.x"    "::src:menu_princ.c"
"{ObjDir}objet.c.x"    "::src:objet.c"
"{ObjDir}reseau.c.x"    "::src:reseau.c"
"{ObjDir}reseau_inter.c.x"    "::src:reseau_inter.c"
"{ObjDir}slime.c.x"    "::src:slime.c"
"{ObjDir}themes_general.c.x"    "::src:themes_general.c"
"{ObjDir}themes_os9.c.x"    "::src:themes_os9.c"


### Optional Dependencies ###
### Build this target to generate "include file" dependencies. ###

Dependencies    $OutOfDate
	MakeDepend 
		-append {MAKEFILE} 
		-ignore "{CIncludes}" 
		-ignore "{RIncludes}" 
		-objdir "{ObjDir}" 
		-objext .x 
		{Includes} 
		{SrcFiles}


